<?php

namespace Modules\Banner\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

use Yajra\DataTables\Facades\DataTables;
use Kalnoy\Nestedset\NestedSet;

use Modules\Mwz\Http\Controllers\MwzController;
use Modules\Banner\Entities\BannerCategories;
use Modules\Banner\Entities\Banners;


class BannerAdminController extends Controller
{
    /**
     * Function : __construct check admin login
     * Dev : pop
     * Update Date : 23 Jul 2021
     * @param Get
     * @return if not login redirect to /admin
     */
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    /**
     * Function : banner index
     * Dev : pop
     * Update Date : 27 Jul 2021
     * @param Get
     * @return index.blade view
     */
    public function index()
    {

        return view('banner::index');
    }

    /**
     * Function : banner datatable ajax response
     * Dev : pop
     * Update Date : 27 Jul 2021
     * @param Get
     * @return json of banner
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {

            //init datatable
            $dt_name_column = array('_lft', 'image', 'sequence', 'updated_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create banners object
            $o_banner = new Banners;

            // count all banners
            $dt_total = Banners::count();

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_banner->where('sequence', 'like', "%" . $dt_search . "%")
                    ->where('name_th', 'like', "%" . $dt_search . "%")
                    ->where('image', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_banner->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query banners
            // query career as tree resule
            $banners = $o_banner
                ->join('banner_categories', 'banners.category_id', '=', 'banner_categories.id')
                ->select('banners.id', 'banners.link_youtube', 'banners.category_id', 'banners.sequence', 'banners.image', 'banner_categories.name_th', 'banners.updated_at', 'banners.status')
                ->get();

            // count all category
            $dt_total = $banners->count();

            // prepare datatable for response
            $tables = Datatables::of($banners)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('banner_row')
                ->setTotalRecords($dt_total)
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i:s');
                })
                ->editColumn('image', function ($record) {
                    if ($record->image != "" && CheckFileInServer($record->image)) {
                        $img = '<img src="' . $record->image . '" class="w-8" />';
                    } else if ($record->link_youtube != "") {
                        $img = '<div class="set-size-video">';
                        $img .= $record->link_youtube;
                        $img .= '</div>';
                    }else{
                        $img = '<img src="/storage/no_image/1920-1080.png" class="w-8" />';
                    }
                    return $img;
                })
                ->editColumn('category', function ($record) {
                    return $record->category_id;
                })
                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';
                    if ($record->status == 1) {
                        $action_btn .= '<a onclick="setUpdateStatus(' . $record->id . ',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                    } else {
                        $action_btn .=  '<a onclick="setUpdateStatus(' . $record->id . ',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                    }

                    $action_btn .= '<a href="' . route('admin.banner.banner.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : add banner form
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param GET
     * @return banner form view
     */
    public function form_banner($id = 0)
    {
        $banner = [];

        if (!empty($id)) {
            $banner = Banners::find($id);
            $banner->description_th = mwz_getTextString($banner->description_th);
            $banner->description_en = mwz_getTextString($banner->description_en);
        }

        $categories = mwz_setFlatCategory(BannerCategories::all()->totree());

        return view('banner::form', ['categories' => $categories, 'banner' => $banner]);
    }

    /**
     * Function :  banner save
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json response status
     */
    public function save_banner(Request $request)
    {
        //check input is null

        if ($request->get('sequence') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุลำดับในการแสดงผล!', 'focus' => 'sequence'];
            return response()->json($resp);
        }

        if (empty($request->get('id'))) {
            $validator = Validator::make($request->all(), [
                'id' => 'integer',
                'sequence' => 'required|integer',
            ]);
        } else {
            $validator = Validator::make($request->all(), [
                'id' => 'integer',
                'sequence' => 'required|integer',
            ]);
        }

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 301, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "category_id" => $request->get('category_id'),
            "sequence" => $request->get('sequence'),
            "link_youtube" => $request->get('link_youtube'),
            "status" => $request->get('status'),
            "link_destination" => $request->get('link_destination'),
            "description_th" => mwz_setTextString($request->get('description_th')),
            "description_en" => mwz_setTextString($request->get('description_en'))
        ];

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $new_filename = time() . "." . $image->extension();
            $path = $image->storeAs(
                'public/banner',
                $new_filename
            );
            $attributes['image'] = Storage::url($path);
        }

        if (!empty($request->get('id'))) {
            $Banner = Banners::where('id', $request->get('id'))->update($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
        } else {
            $Banner = Banners::create($attributes);
            $resp = ['success' => 1, 'code' => 201, 'msg' => 'เพิ่มรายการใหม่สำเร็จ'];
        }

        return response()->json($resp);
    }

    /**
     * Function : update banner status
     * Dev : pop
     * Update Date : 27 Jul 2021
     * @param POST
     * @return json of update status
     */
    public function set_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $banner = Banners::find($id);
            $banner->status = $status;

            if ($banner->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function : delete image
     * Dev : Ta
     * Update Date : 25 Aug 2021
     * @param POST
     * @return json of response
     */
    public function delete_image(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');

            $banner = Banners::find($id);
            $banner->image = '';

            if ($banner->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }
}
