<?php

namespace Modules\Banner\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BannerDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $now = DB::raw('NOW()');
        DB::statement("ALTER TABLE banner_categories AUTO_INCREMENT=1");
        DB::table('banner_categories')->truncate();
        DB::table('banner_categories')->insert([
            ['id'=> 1,
            'name_th' => 'หน้าหลัก',
            'name_en' => 'HOME',
            'status' =>1,
            '_lft' => 1,
            '_rgt' => 2,
            'created_at'=>$now,
            'updated_at'=>$now,],

            ['id'=> 2,
            'name_th' => 'บริการ',
            'name_en' => 'SERVICES',
            'status' =>1,
            '_lft' => 3,
            '_rgt' => 4,
            'created_at'=>$now,
            'updated_at'=>$now]
        ]);

        DB::statement("ALTER TABLE banners AUTO_INCREMENT=1");
        DB::table('banners')->truncate();
        DB::table('banners')->insert([
            ['id'  => 1,
            'category_id'  => 2,
            'image'=> '',
            'link_youtube'=>'https://www.youtube.com/watch?v=6jZVsr7q-tE',
            'sequence'=> '1',
            'status' =>1,
            'created_at'=>$now,
            'updated_at'=>$now],

            ['id'  => 2,
            'category_id'  => 1,
            'image'=> '',
            'link_youtube'=>'',
            'sequence'=> '1',
            'status' =>1,
            'created_at'=>$now,
            'updated_at'=>$now],

            ['id'  => 3,
            'category_id'  => 1,
            'image'=> '',
            'link_youtube'=>'',
            'sequence'=> '2',
            'status' =>1,
            'created_at'=>$now,
            'updated_at'=>$now],

            ['id'  => 4,
            'category_id'  => 1,
            'image'=> '',
            'link_youtube'=>'',
            'sequence'=> '3',
            'status' =>1,
            'created_at'=>$now,
            'updated_at'=>$now],
            
            ['id'  => 5,
            'category_id'  => 1,
            'image'=> '',
            'link_youtube'=>'',
            'sequence'=> '4',
            'status' =>1,
            'created_at'=>$now,
            'updated_at'=>$now],
        ]);
    }
}
