<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Kalnoy\Nestedset\NestedSet;

class CreateBannerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banner_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name_th',500);
            $table->string('name_en',500);
            $table->boolean('status')->default(0);
            NestedSet::columns($table);
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
        Schema::create('banners', function (Blueprint $table) {
            $table->id();
            $table->boolean('category_id');
            $table->string('image',700)->nullable();
            $table->string('link_youtube',700)->nullable();
            $table->string('link_destination',700)->nullable();
            $table->text('description_th')->nullable();
            $table->text('description_en')->nullable();
            $table->tinyInteger('sequence')->comment = 'ลำดับในการแสดงผล';
            $table->boolean('status')->default(0);
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banner_categories');
        Schema::dropIfExists('banner');
    }
}
