<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'auth:admin'], function () {
    Route::prefix('admin/about')->group(function () {
        Route::get('/index', 'AboutUsAdminController@index')->name('admin.about.about.index');
        Route::get('/datatable_ajax', 'AboutUsAdminController@datatable_ajax')->name('admin.about.about.datatable_ajax');

        Route::get('/edit/1', 'AboutUsAdminController@form')->name('admin.about.about.edit');
        Route::post('/save', 'AboutUsAdminController@save')->name('admin.about.about.save');

        Route::post('/set_status', 'AboutUsAdminController@set_status')->name('admin.about.about.set_status');

        Route::get('/teams', 'AboutUsAdminController@index_team')->name('admin.about.teams.index');
        Route::get('/datatableteam_ajax', 'AboutUsAdminController@datatableteam_ajax')->name('admin.about.teams.datatableteam_ajax');

        Route::get('/add_team', 'AboutUsAdminController@form_team')->name('admin.about.teams.add');
        Route::get('/edit_team/{category_id}', 'AboutUsAdminController@form_team')->name('admin.about.teams.edit');
        Route::post('/save/team', 'AboutUsAdminController@save_team')->name('admin.about.teams.save');

        Route::post('/set_team_status', 'AboutUsAdminController@set_team_status')->name('admin.about.teams.set_team_status');
        Route::post('/set_delete', 'AboutUsAdminController@set_delete')->name('admin.about.teams.set_delete');

        Route::get('/partner', 'AboutUsAdminController@index_partner')->name('admin.about.partner.index');
        Route::get('/datatablepartner_ajax', 'AboutUsAdminController@datatablepartner_ajax')->name('admin.about.partner.datatablepartner_ajax');

        Route::get('/add_partner', 'AboutUsAdminController@form_partner')->name('admin.about.partner.add');
        Route::get('/edit_partner/{category_id}', 'AboutUsAdminController@form_partner')->name('admin.about.partner.edit');
        Route::post('/save_partner', 'AboutUsAdminController@save_partner')->name('admin.about.partner.save');

        Route::post('/set_partner_status', 'AboutUsAdminController@set_partner_status')->name('admin.about.partner.set_partner_status');
        Route::post('/set_partner_delete', 'AboutUsAdminController@set_partner_delete')->name('admin.about.partner.set_partner_delete');

        Route::post('/team/header_team', 'AboutUsAdminController@header_team')->name('admin.about.team.header_team');
        Route::post('/partner/header_partner', 'AboutUsAdminController@header_partner')->name('admin.about.partner.header_partner');
        Route::post('/delete_image', 'AboutUsAdminController@delete_image')->name('admin.about.delete_image');
    });
});
