<?php

namespace Modules\AboutUs\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;
use Modules\AboutUs\Entities\AboutUs;
use Modules\AboutUs\Entities\AboutTeams;
use Modules\AboutUs\Entities\AboutPartners;

class AboutUsAdminController extends Controller
{

    /**
     * Function : __construct check admin login
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return if not login redirect to /admin
     */
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    /**
     * Function : about index
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return index.blade view
     */
    public function index()
    {

        return view('aboutus::index');
    }

    /**
     * Function : about datatable ajax response
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return json of about
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {

            //init datatable
            $dt_name_column = array('_lft', 'updated_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // count all abouts
            $dt_total = AboutUs::count();

            // create abouts object
            $o_about = new AboutUs;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_about->where('updated_at', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_about->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query abouts
            $abouts = $o_about->get();

            // prepare datatable for response
            $tables = Datatables::of($abouts)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('about_row')
                ->setTotalRecords($dt_total)
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i:s');
                })
                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';

                    if ($record->status == 1) {
                        $action_btn .= '<a onclick="setUpdateStatus(' . $record->id . ',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                    } else {
                        $action_btn .=  '<a onclick="setUpdateStatus(' . $record->id . ',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                    }

                    $action_btn .= '<a href="' . route('admin.about.about.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';

                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : add con$contactus form
     * Dev : pop
     * Update Date : 04 August 2021
     * @param GET
     * @return category form view
     */
    public function form($id = 1)
    {
        $about = [];
        if (!empty($id)) {
            $about = AboutUs::find($id);
        }
        return view('aboutus::form', ['about' => $about]);
    }

    /**
     * Function :  about save
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json response status
     */
    public function save(Request $request)
    {
        // dd($request->get('description_story_th'));
        $attributes = [
            "description_story_th" => mwz_setTextString($request->get('description_story_th')),
            "description_story_en" => mwz_setTextString($request->get('description_story_en')),
            "description_vision_th" => mwz_setTextString($request->get('description_vision_th')),
            "description_vision_en" => mwz_setTextString($request->get('description_vision_en')),
            "about_header_th" => mwz_setTextString($request->get('about_header_th')),
            "about_header_en" => mwz_setTextString($request->get('about_header_en'))
        ];


        if ($request->hasFile('file1')) {
            $file = $request->file('file1');
            $new_filename = time() . "_1" . "." . $file->extension();
            $path = $file->storeAs(
                'public/aboutus',
                $new_filename
            );
            $attributes['file_about1'] = Storage::url($path);
        }

        if ($request->hasFile('file2')) {
            $file = $request->file('file2');
            $new_filename = time() . "_2" . "." . $file->extension();
            $path = $file->storeAs(
                'public/aboutus',
                $new_filename
            );
            $attributes['file_about2'] = Storage::url($path);
        }

        if ($request->hasFile('image_story')) {
            $image = $request->file('image_story');
            $new_filename = time() . "." . $image->extension();
            $path = $image->storeAs(
                'public/aboutus',
                $new_filename
            );
            $attributes['image_story'] = Storage::url($path);
        }

        if (!empty($request->get('id'))) {
            $AboutUs = AboutUs::where('id', $request->get('id'))->update($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
        } else {
            $AboutUs = AboutUs::create($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'เพิ่มรายการใหม่สำเร็จ'];
        }

        return response()->json($resp);
    }



    /**
     * Function : update about status
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json of update status
     */
    public function set_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $about = AboutUs::find($id);
            $about->status = $status;

            if ($about->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function : aboutus teams index
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return index.blade view
     */
    public function index_team()
    {
        $about = AboutUs::find(1);

        return view('aboutus::index_teams', ['about' => $about]);
    }


    /**
     * Function : aboutus team datatable ajax response
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return json of about
     */
    public function datatableteam_ajax(Request $request)
    {
        if ($request->ajax()) {

            //init datatable
            $dt_name_column = array('_lft', 'image', 'fullname_th', 'updated_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // count all abouts
            $dt_total = AboutTeams::count();

            // create abouts object
            $o_about = new AboutTeams;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_about->where('fullname_th', 'like', "%" . $dt_search . "%")
                    ->where('fullname_en', 'like', "%" . $dt_search . "%")
                    ->where('sequence', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_about->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query abouts
            $abouts = $o_about->get();

            // prepare datatable for response
            $tables = Datatables::of($abouts)
                ->addIndexColumn()
                ->setRowId('sequence')
                ->setRowClass('about_row')
                ->setTotalRecords($dt_total)
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i:s');
                })
                ->editColumn('image', function ($record) {
                    if ($record->image != "" && CheckFileInServer($record->image)) {
                        $image = '<img src="' . $record->image . '" class="w-6" alt="">';
                    } else {
                        $image = '<img src="/storage/no_image_360-515.png" class="w-6" alt="">';
                    }
                    return $image;
                })

                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';
                    if ($record->status == 1) {
                        $action_btn .= '<a onclick="setStatusTeam(' . $record->id . ',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                    } else {
                        $action_btn .=  '<a onclick="setStatusTeam(' . $record->id . ',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                    }

                    $action_btn .= '<a href="' . route('admin.about.teams.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : update about team status
     * Dev : pop
     * Update Date : 11 Auqust 2021
     * @param POST
     * @return json of update status
     */
    public function set_team_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $about_team = AboutTeams::find($id);
            $about_team->status = $status;

            if ($about_team->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function : delete team
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json of delete status
     */
    public function set_delete(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $team = AboutTeams::find($id);

            if ($team->delete()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function : add form_team
     * Dev : pop
     * Update Date : 04 August 2021
     * @param GET
     * @return category form view
     */
    public function form_team($id = 0)
    {
        $team = [];
        if (!empty($id)) {
            $team = AboutTeams::find($id);
        }
        return view('aboutus::form_team', ['team' => $team]);
    }

    /**
     * Function :  about team save
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json response status
     */
    public function save_team(Request $request)
    {
        if (empty($request->get('fullname_th'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อ-นามสกุลภาษาไทย!', 'focus' => 'fullname_th'];
            return response()->json($resp);
        }
        if (empty($request->get('fullname_en'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อ-นามสกุลภาษาอังกฤษ!', 'focus' => 'fullname_en'];
            return response()->json($resp);
        }
        if (empty($request->get('position_th'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุตำแหน่งภาษาไทย!', 'focus' => 'position_th'];
            return response()->json($resp);
        }
        if (empty($request->get('position_en'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุตำแหน่งภาษาอังกฤษ!', 'focus' => 'position_en'];
            return response()->json($resp);
        }
        if (empty($request->get('sequence'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุลำดับการแสดงผล!', 'focus' => 'sequence'];
            return response()->json($resp);
        }

        $validator = Validator::make($request->all(), [
            'id' => 'integer',
            'fullname_th' => 'required|max:250',
            'fullname_en' => 'required|max:250',
            'position_th' => 'required|max:250',
            'position_en' => 'required|max:250',
            'sequence' => 'required',
            'status' => 'required',
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 301, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "fullname_th" => $request->get('fullname_th'),
            "fullname_en" => $request->get('fullname_en'),
            "position_th" => $request->get('position_th'),
            "position_en" => $request->get('position_en'),
            "sequence" => $request->get('sequence'),
            "status" => $request->get('status')
        ];


        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $new_filename = time() . "." . $image->extension();
            $path = $image->storeAs(
                'public/aboutus',
                $new_filename
            );
            $attributes['image'] = Storage::url($path);
        }


        if (!empty($request->get('id'))) {
            $AboutTeams = AboutTeams::where('id', $request->get('id'))->update($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
        } else {
            $AboutTeams = AboutTeams::create($attributes);
            $resp = ['success' => 1, 'code' => 201, 'msg' => 'เพิ่มรายการใหม่สำเร็จ'];
        }

        return response()->json($resp);
    }

    /**
     * Function : aboutus partner index
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return index.blade view
     */
    public function index_partner()
    {
        $about = AboutUs::find(1);
        return view('aboutus::index_partner', ['about' => $about]);
    }

    /**
     * Function : aboutus partner datatable ajax response
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return json of about
     */
    public function datatablepartner_ajax(Request $request)
    {
        if ($request->ajax()) {

            //init datatable
            $dt_name_column = array('id', 'sequence', 'image', 'name_th', 'name_en', 'updated_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // count all abouts
            $dt_total = AboutPartners::count();

            // create abouts object
            $o_about = new AboutPartners;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_about->where('updated_at', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_about->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query abouts
            $abouts = $o_about->get();

            // prepare datatable for response
            $tables = Datatables::of($abouts)
                ->addIndexColumn()
                ->setRowId('sequence')
                ->setRowClass('partner_row')
                ->setTotalRecords($dt_total)
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i:s');
                })
                ->editColumn('image', function ($record) {
                    if ($record->image != '' && CheckFileInServer($record->image)) {
                        $image = '<img src="' . $record->image . '" class="w-6" />';
                    } else {
                        $image = '<img src="/storage/no_image/265-265.png" class="w-6" />';
                    }
                    return $image;
                })

                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';
                    if ($record->status == 1) {
                        $action_btn .= '<a onclick="setStatusPartner(' . $record->id . ',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                    } else {
                        $action_btn .=  '<a onclick="setStatusPartner(' . $record->id . ',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                    }

                    $action_btn .= '<a href="' . route('admin.about.partner.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';
                    $action_btn .= '<a onclick="setPartnerDelete(' . $record->id . ')" href="javascript:void(0);" class="btn btn-outline-danger"><i class="fa fa-trash"></i></a></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : update about partner status
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json of update status
     */
    public function set_partner_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $about = AboutPartners::find($id);
            $about->status = $status;

            if ($about->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }


    /**
     * Function : delete about partner
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json of delete status
     */
    public function set_partner_delete(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $partner = AboutPartners::find($id);

            if ($partner->delete()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function : edit about partner form
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param GET
     * @return banner form view
     */
    public function form_partner($id = 0)
    {
        $partner = [];

        if (!empty($id)) {
            $partner = AboutPartners::find($id);
        }
        return view('aboutus::form_partner', ['partner' => $partner]);
    }

    /**
     * Function :  about partner save
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json response status
     */
    public function save_partner(Request $request)
    {
        if (empty($request->get('link'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุ link !', 'focus' => 'link'];
            return response()->json($resp);
        }

        if (empty($request->get('name_th'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อบริษัทภาษาไทย !', 'focus' => 'name_th'];
            return response()->json($resp);
        }

        if (empty($request->get('name_en'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อบริษัทภาษาอังกฤษ !', 'focus' => 'name_en'];
            return response()->json($resp);
        }

        if (empty($request->get('sequence'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุลำดับในการแสดงผล !', 'focus' => 'sequence'];
            return response()->json($resp);
        }


        //validate post data
        if (empty($request->get('id'))) {
            $validator = Validator::make($request->all(), [
                'id' => 'integer',
                'link' => 'required',
                'name_th' => 'required',
                'name_en' => 'required',
                'status' => 'required|integer',
                'sequence' => 'required|integer',
            ]);
        } else {
            $validator = Validator::make($request->all(), [
                'id' => 'integer',
                'link' => 'required',
                'name_th' => 'required',
                'name_en' => 'required',
                'status' => 'required|integer',
                'sequence' => 'required|integer',
            ]);
        }

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 301, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "link" => $request->get('link'),
            "name_en" => $request->get('name_en'),
            "name_th" => $request->get('name_th'),
            "status" => $request->get('status'),
            "sequence" => $request->get('sequence')
        ];


        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $new_filename = time() . "." . $image->extension();
            $path = $image->storeAs(
                'public/aboutus',
                $new_filename
            );
            $attributes['image'] = Storage::url($path);
        }


        if (!empty($request->get('id'))) {
            $Partner = AboutPartners::where('id', $request->get('id'))->update($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
        } else {
            $Partner = AboutPartners::create($attributes);
            $resp = ['success' => 1, 'code' => 201, 'msg' => 'เพิ่มรายการใหม่สำเร็จ'];
        }

        return response()->json($resp);
    }

    public function header_team(Request $request)
    {
        $attributes = [
            "description_team_th" => $request->get('description_team_th'),
            "description_team_en" => $request->get('description_team_en'),
        ];

        $Header_Team = AboutUs::where('id', 1)->update($attributes);
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];

        return response()->json($resp);
    }

    public function header_partner(Request $request)
    {
        $attributes = [
            "description_partner_th" => $request->get('description_partner_th'),
            "description_partner_en" => $request->get('description_partner_en'),
        ];

        $Header_Partner = AboutUs::where('id', 1)->update($attributes);
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];

        return response()->json($resp);
    }

    /**
     * Function : delete image
     * Dev : Ta
     * Update Date : 25 Aug 2021
     * @param POST
     * @return json of response
     */
    public function delete_image(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $type = $request->get('type');

            if ($type == 1) {
                $about = AboutUs::find($id);
                $about->image_story = '';

                if ($about->save()) {
                    $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
                } else {
                    $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
                }
            } else if ($type == 2) {
                $about = AboutTeams::find($id);
                $about->image = '';

                if ($about->save()) {
                    $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
                } else {
                    $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
                }
            } else {
                $about = AboutPartners::find($id);
                $about->image = '';

                if ($about->save()) {
                    $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
                } else {
                    $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
                }
            }

            return response()->json($resp);
        }
    }
}
