<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAboutTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('about_us', function (Blueprint $table) {
            $table->id();
            $table->string('image_story', 700)->nullable();
            $table->text('about_header_th')->nullable();
            $table->text('about_header_en')->nullable();
            $table->text('description_story_th')->nullable();
            $table->text('description_story_en')->nullable();
            $table->string('file_about1', 700)->nullable();
            $table->string('file_about2', 700)->nullable();
            $table->text('description_team_th')->nullable();
            $table->text('description_team_en')->nullable();
            $table->text('description_partner_th')->nullable();
            $table->text('description_partner_en')->nullable();
            $table->text('description_vision_th')->nullable();
            $table->text('description_vision_en')->nullable();
            $table->timestamps();
        });

        Schema::create('about_teams', function (Blueprint $table) {
            $table->id();
            $table->string('fullname_th', 500);
            $table->string('fullname_en', 500);
            $table->string('image', 700)->nullable();
            $table->string('position_th', 250);
            $table->string('position_en', 250);
            $table->boolean('status')->default(0);
            $table->tinyInteger('sequence')->comment = 'ลำดับในการแสดงผล';
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
        Schema::create('about_partners', function (Blueprint $table) {
            $table->id();
            $table->string('image', 700)->nullable();
            $table->string('name_th', 700);
            $table->string('name_en', 700);
            $table->string('link', 700);
            $table->boolean('status')->default(0);
            $table->tinyInteger('sequence')->comment = 'ลำดับในการแสดงผล';
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('about_us');
        Schema::dropIfExists('about_teams');
        Schema::dropIfExists('about_partners');
    }
}
